/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import mcjty.lib.compat.patchouli.PatchouliCompatibility;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PacketOpenManual {
    private final ResourceLocation manual;
    private final ResourceLocation entry;
    private final int page;

    public PacketOpenManual(FriendlyByteBuf buf) {
        this.manual = buf.m_130281_();
        this.entry = buf.m_130281_();
        this.page = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.manual);
        buf.m_130085_(this.entry);
        buf.writeInt(this.page);
    }

    public PacketOpenManual(ResourceLocation manual, ResourceLocation entry, int page) {
        this.manual = manual;
        this.entry = entry;
        this.page = page;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketOpenManual.handle(this, (NetworkEvent.Context)ctx.get()));
        ctx.get().setPacketHandled(true);
    }

    private static void handle(PacketOpenManual message, NetworkEvent.Context ctx) {
        ServerPlayer playerEntity = ctx.getSender();
        PatchouliCompatibility.openBookEntry(playerEntity, message.manual, message.entry, message.page);
    }
}

